#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Hexagonal Voronoi Line DistanceMod01.fsh  by Shane   
//https://www.shadertoy.com/view/4dSfzD
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*

	Hexagonal Voronoi Line Distance
	-------------------------------

	As the lacklustre title suggests, this is a hexagonal Voronoi implementation of the 
	"point to nearest cell edge distance" formula. It uses fewer taps than the square
	grid versions, but those gains are probably offset by the hexagonal transforms, etc. 
	I kind of prefer the square grid version, but I thought it'd be nice to put this up 
	for comparison, and just in case someone required a reference.

	Dr2 has been putting up a few hexagonal Voronoi examples lately. I was going to
	incorporate his code, but I thought I'd use one of my own versions, just to provide
	a mildly different perspective. It uses cheaper hexagonal transforms, but that may 
	be at the expense of less variation in point spread... I'm not sure.

	I did this for the novelty. Feel free to check out the Voronoi function, but it's
	pretty straight forward. Basically, you convert to a hexagonal grid, offset cell 
	center points, find the nearest cell point, then perform another pass to determine the 
	nearest edge to the nearest cell point. As you can see, the edges are pretty uniform.

	The rest is just some very lazy prettying up. In case it isn't obvious, visually
	speaking, this is just a rehash of my last example with a few simple changes. The
	effects are all fake. It's a essentially a bump mapped example with some shading to
	give the impression of some shadowing.

	// Other examples:

    // Another hexagonal Voronoi edge example using a more relaxed, but faster, method.
    Voronoi Of The Week - Dr2
	https://www.shadertoy.com/view/lsjBz1

	// The original point to nearest edge example.
	Voronoi distances - iq
	https://www.shadertoy.com/view/ldl3W8
	// His well written article that describes the process in more detail.
	// https://iquilezles.org/articles/voronoilines

*/

//#define SCROLL

// vec2 to vec2 hash.
vec2 hash22(vec2 p) { 

    // Faster, but doesn't disperse things quite as nicely. However, when framerate
    // is an issue, and it often is, this is a good one to use. Basically, it's a tweaked 
    // amalgamation I put together, based on a couple of other random algorithms I've 
    // seen around... so use it with caution, because I make a tonne of mistakes. :)
    float n = sin(dot(p, vec2(41, 289)));
    
    #ifdef SCROLL
    return fract(vec2(262144, 32768)*n); 
    #else
    // Animated.
    p = fract(vec2(262144, 32768)*n); 
    return sin( p*6.2831853 + iTime )*.5 + .5; 
    #endif
}

// IQ's polynomial-based smooth minimum function.
float smin( float a, float b, float k ){

    float h = clamp(.5 + .5*(b - a)/k, 0., 1.);
    return mix(b, a, h) - k*h*(1. - h);
}

// IQ's exponential-based smooth minimum function. Unlike the polynomial-based
// smooth minimum, this one is associative and commutative.
float sminExp(float a, float b, float k){
    
    float res = exp(-k*a) + exp(-k*b);
    return -log(res)/k;
}

// Converting to the hexagonal grid.
vec2 pixToHex(vec2 p){
    
    return floor(vec2(p.x + .57735*p.y, 1.1547*p.y) + 1./3.);
}

// Randomized hexagonal offset point.
vec2 hexPt(vec2 p) {

    // The offset value is restricted to the radius of the incircle of the
    // hexagon, or apothem as it's technically known.
    return vec2(p.x - p.y*.5, .8660254*p.y) + (hash22(p) - .5)*.8660254/2.;
    
}


// Scene object ID, and individual cell IDs. Used for coloring.
float objID; // The rounded web lattice, or the individual Voronoi cells.
//vec2 cellID; // Individual Voronoi cell IDs.

// This is a hexagonal variation on a regular 2-pass Voronoi traversal that produces
// a Voronoi pattern based on the interior cell point to the nearest cell edge (as opposed
// to the nearest offset point). It uses element from an old hexagonal Voronoi example, 
// and is based on IQ's original example. It was inspired by Dr2's hexagonal examples.
// The links are below:
//
// On a side note, I have no idea whether a faster solution is possible, but when I
// have time, I'm going to attempt to find one anyway.
//
// Voronoi distances - iq
// https://www.shadertoy.com/view/ldl3W8
//
// Here's IQ's well written article that describes the process in more detail.
// https://iquilezles.org/articles/voronoilines
//
// Desert Town - dr2
// https://www.shadertoy.com/view/XslBDl
vec3 Voronoi(vec2 p){
    
    // Convert to the hexagonal grid.
    vec2 pH = pixToHex(p); // Map the pixel to the hex grid.

    // There'd be a heap of ways to get rid of this array and speed things up. The
    // most obvious, would be unrolling the loops, but there'd be more elegant ways.
    // Either way, I've left it this way just to make the code easier to read.
 
    // Hexagonal grid offsets. "vec2(0)" represents the center, and the other offsets effectively circle it.
    // Thanks, Abje. Hopefully, the compiler will know what to do with this. :)
	const vec2 hp[7] = vec2[7](vec2(-1), vec2(0, -1), vec2(-1, 0), vec2(0), vec2(1), vec2(1, 0), vec2(0, 1)); 
    
    
    // Voronoi cell ID containing the minimum offset point distance. The nearest
    // edge will be one of the cells edges.
    vec2 minCellID = vec2(0); // Redundant initialization, but I've done it anyway.

    // As IQ has commented, this is a regular Voronoi pass, so it should be
    // pretty self explanatory.
    //
    // First pass: Regular Voronoi.
	vec2 mo, o;
    
    // Minimum distance, "smooth" distance to the nearest cell edge, regular
    // distance to the nearest cell edge, and a line distance place holder.
    float md = 8., lMd = 8., lMd2 = 8., lnDist, d;
    
    for (int i=0; i<7; i++){
    
        // Determine the offset hexagonal point.
        vec2 h = hexPt(pH + hp[i]) - p;
        // Determine the distance metric to the point.
    	d = dot(h, h);
    	if( d<md ){ // Perform updates, if applicable.
            
            md = d;  // Update the minimum distance.
            // Keep note of the position of the nearest cell point - with respect
            // to "p," of course. It will be used in the second pass.
            mo = h; 
            //cellID = h + p; // For cell coloring.
            minCellID = hp[i]; // Record the minimum distance cell ID.
        }
    }
    
    // Second pass: Point to nearest cell-edge distance.
    //
    // With the ID of the cell containing the closest point, do a sweep of all the
    // surrounding cell edges to determine the closest one. You do that by applying
    // a standard distance to a line formula.
    for (int i=0; i<7; i++){
    
         // Determine the offset hexagonal point in relation to the minimum cell offset.
        vec2 h = hexPt(pH + hp[i] + minCellID) - p - mo; // Note the "-mo" to save some operations. 
        
        // Skip the same cell.
        if(dot(h, h)>.00001){
            
            // This tiny line is the crux of the whole example, believe it or not. Basically, it's
            // a bit of simple trigonometry to determine the distance from the cell point to the
            // cell border line. See IQ's article (link above) for a visual representation.            
            lnDist = dot(mo + h*.5, normalize(h));
            
            // Abje's addition. Border distance using a smooth minimum. Insightful, and simple.
            //
            // On a side note, IQ reminded me that the order in which the polynomial-based smooth
            // minimum is applied effects the result. However, the exponentional-based smooth
            // minimum is associative and commutative, so is more correct. In this particular case, 
            // the effects appear to be negligible, so I'm sticking with the cheaper polynomial-based
            // smooth minimum, but it's something you should keep in mind. By the way, feel free to 
            // uncomment the exponential one and try it out to see if you notice a difference.
            //
            // Polynomial-based smooth minimum. The last factor controls the roundness of the 
            // edge joins. Zero gives you sharp joins, and something like ".25" will produce a
            // more rounded look.
            lMd = smin(lMd, lnDist, .1);
            // Exponential-based smooth minimum.
            //lMd = sminExp(lMd, lnDist, 20.); 
            
            // Minimum regular straight-edged border distance. If you only used this distance,
            // the web lattice would have sharp edges.
            lMd2 = min(lMd2, lnDist);
            
        }

    }

    // Return the smoothed and unsmoothed distance. I think they need capping at zero... but I'm not 
    // positive. Although not used here, the standard minimum point distance is returned also.
    return max(vec3(lMd, lMd2, md), 0.);
    
    
}

// This is a bit messy. I'll tidy it up later, but it's basically just playing with
// the Voronoi isovalues to geometrically show some lines, and so forth.
float bumpFunc(vec2 p){ 

    vec3 v = Voronoi(p*4.);
	float c = v.x; // Range: [0, 1]
    
    // ID - used for scene object coloring.
    objID = 0.;
    
    const float edge = .08;
    const float edge2 = .08;
    
    if( c<edge) { // Main outer borders.
        c = ((edge - c)/edge)*.1;
        objID = 1.;
    }
    else {
       c = (v.x - edge)/(1. - edge);
        
       if(c>edge2) { // Inner cells.
           objID = 2.;
           c = (v.y - edge2)/(1. - edge2)*2.;
           
        }
        else { // Dark, inner borders.
            c = abs(c - edge2)/(1. - edge2);
           
        }
    }
    
    // Return the manipulated Voronoi value.
    return c;

}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 

    // Screen coordinates.
	vec2 uv = (fragCoord - iResolution.xy*.5)/iResolution.y;



    // VECTOR SETUP - surface postion, ray origin, unit direction vector, and light postion.
    //
    // Setup: I find 2D bump mapping more intuitive to pretend I'm raytracing, then lighting a bump mapped plane 
    // situated at the origin. Others may disagree. :)  
    vec3 sp = vec3(uv, 0); // Surface posion. Hit point, if you prefer. Essentially, a screen at the origin.
    vec3 rd = normalize(vec3(uv, 1.)); // Unit direction vector. From the origin to the screen plane.
    vec3 lp = vec3(cos(iTime)*0.15 + .1, sin(iTime)*0.15 + .1, -1.); // Light position - Back from the screen.
	vec3 sn = vec3(0., 0., -1); // Plane normal. Z pointing toward the viewer.
 
	// Scrolling.
    #ifdef SCROLL
    sp.x -= iTime/8.;
    lp.x -= iTime/8.;
    #endif     

    
    // BUMP MAPPING - PERTURBING THE NORMAL
    //
    // Setting up the bump mapping variables. Normally, you'd amalgamate a lot of the following,
    // and roll it into a single function, but I wanted to show the workings.
    //
    // f - Function value
    // fx - Change in "f" in in the X-direction.
    // fy - Change in "f" in in the Y-direction.
    vec2 eps = vec2(2./iResolution.y, 0.);
    
    float f = bumpFunc(sp.xy); // Sample value multiplied by the amplitude.
    
    float svObjID = objID; // Save the object ID here.
    float fx = bumpFunc(sp.xy - eps.xy); // Same for the nearby sample in the X-direction.
    float fy = bumpFunc(sp.xy - eps.yx); // Same for the nearby sample in the Y-direction.
  
    float fx2 = bumpFunc(sp.xy + eps.xy); // Same for the nearby sample in the X-direction.
    float fy2 = bumpFunc(sp.xy + eps.yx); // Same for the nearby sample in the Y-direction.
    float edge = abs(fx + fy + fx2 + fy2 - 4.*f);//abs(fx - f)+ abs(fy - f);
    edge = smoothstep(0., 8., edge/eps.x);//sqrt(edge/eps.x*8.)
   
 	// Controls how much the bump is accentuated.
	float bumpFactor = .1;
    
    // Using the above to determine the dx and dy function gradients.
    fx = (fx - f)/eps.x; // Change in X
    fy = (fy - f)/eps.x; // Change in Y.
    // Using the gradient vector, "vec3(fx, fy, 0)," to perturb the XY plane normal ",vec3(0, 0, -1)."
    // By the way, there's a redundant step I'm skipping in this particular case, on account of the 
    // normal only having a Z-component. Normally, though, you'd need the commented stuff below.
    //vec3 grad = vec3(fx, fy, 0);
    //grad -= sn*dot(sn, grad);
    //sn = normalize( sn + grad*bumpFactor ); 
    sn = normalize( sn + vec3(fx, fy, 0)*bumpFactor );           
   
    
    // LIGHTING
    //
	// Determine the light direction vector, calculate its distance, then normalize it.
	vec3 ld = lp - sp;
	float lDist = max(length(ld), 0.001);
	ld /= lDist;

    // Light attenuation.    
    float atten = 1./(1. + lDist*lDist*0.15);
    
    // Using the bump function, "f," to darken the crevices. Completely optional, but I
    // find it gives extra depth or the impression of ambient occlusion.
    atten *= f*.7 + .3; // Or... f*f*.7 + .3; //  pow(f, .75); // etc.

	

	// Diffuse value.
	float diff = max(dot(sn, ld), 0.);  
    // Enhancing the diffuse value a bit. Made up.
    //diff = pow(diff, 2.)*0.66 + pow(diff, 4.)*0.34; 
    // Specular highlighting.
    float spec = pow(max(dot( reflect(-ld, sn), -rd), 0.), 8.); 

	
    // TEXTURE COLOR
    //
	// Fake tri-planar texel lookup, and by that I mean, I've moved the Z-position up by a fraction
    // of the heightmap amount to give the impression that this is a 3D lookup. The rest is a  regular
    // tri-planar lookup. Not sure if it made a difference, but it can't hurt.
    vec3 nsn = max(abs(sn), .001);
    nsn /= dot(nsn, vec3(1));
    vec3 texCol = vec3(0), txA, txB, txC;
    sp.z = -f*.2; // Moving the Z position out a bit - That's the fake bit.
    txA = texture2D(texture0, sp.xy*2.).xyz;
    txB = texture2D(texture0, sp.zx*2.).xyz;
    txC = texture2D(texture0, sp.yz*2.).xyz;
    // Rough sRGB to linear conversion... That's a whole other conversation. :)
    texCol = txA*txA*nsn.z + txB*txB*nsn.y + txC*txC*nsn.x; 
    texCol = smoothstep(.0, .5, texCol)*2.;
 
    
    if(svObjID>1.5) { // Salmon colored interior cells.
        
        texCol *= vec3(1.85, .7, .65);
        // Some subtle leopard spot patterning.
        texCol *= 1. - smoothstep(0., .05, Voronoi(sp.xy*32.).x - .025)*.25;
        
        // texCol = texCol.yzx; // Other colors, if you prefer. texCol.xzy, etc.
        
        
    }
    else if(svObjID>.5) { // Lighter outer edges.
        texCol *= vec3(1.6, 1, .75);
        // Some subtle reptilian patterning.
        texCol *= smoothstep(0., .05, Voronoi(sp.xy*48.).x - .05)*.35 + .65;
    }
    else texCol *= .25; // Dark inner edges.
        
    

	// Mixing in some subtle purple for a bit more color variance. Made up on the spot.
    texCol = mix(texCol, texCol.zyx, dot(sin(sp.xy*4. + cos(sp.yx*8.)), vec2(.0625)) + .125);
         
    
    // FINAL COLOR
    // Using the values above to produce the final color.   
    vec3 col = (texCol * (diff + 0.25) + vec3(.5, .7, 1)*spec*2.)*atten;

    // Applying a subtle edge outline.
    if(svObjID>1.5) col *= 1. - edge*.65;
    else if(svObjID>.5) col *= 1. - edge*.35;

    // Mixing in the gradient for some fake shadowing.
    col *= min(mix(max(fx, 0.), max(fy, 0.), .5)*.5 + .25, 1.25);
    
    
    
    // Perform some statistically unlikely (but close enough) 2.0 gamma correction. :) 
	fragColor = vec4(sqrt(clamp(col, 0., 1.)), 1.);
    
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

